using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.VFX;
using UnityEngine.VFX.Utility;

[AddComponentMenu("VFX/Property Binders/CubeStream Binder")]
[VFXBinder("CubeStream")]
class CubeStreamBinder : VFXBinderBase
{
    [SerializeField] CubeManager _driver = null;

    public string VolumetricDataProperty
    {
        get => (string)_volumetricDataProperty;
        set => _volumetricDataProperty = value;
    }

    public string PositionDataProperty {
        get => (string)_positionDataProperty;
        set => _positionDataProperty = value;
    }

    public string ValueScaleProperty
    {
        get => (string)_valueScaleProperty;
        set => _valueScaleProperty = value;
    }

    public string PhysicalExtentProperty
    {
        get => (string)_physicalExtentProperty;
        set => _physicalExtentProperty = value;
    }

    [VFXPropertyBinding("UnityEngine.Texture3D"), SerializeField]
    ExposedProperty _volumetricDataProperty = "Volumetric Data";

    [VFXPropertyBinding("UnityEngine.Texture2D"), SerializeField]
    ExposedProperty _positionDataProperty = "Position Data";

    [VFXPropertyBinding("float"), SerializeField]
    ExposedProperty _valueScaleProperty = "Value Scale";

    [VFXPropertyBinding("UnityEngine.Vector3"), SerializeField]
    ExposedProperty _physicalExtentProperty = "Value Scale";

    public override bool IsValid(VisualEffect component)
      => _driver != null &&
         component.HasTexture(_volumetricDataProperty) &&
         component.HasTexture(_positionDataProperty) &&
         component.HasFloat(_valueScaleProperty) &&
         component.HasVector3(_physicalExtentProperty);

    public override void UpdateBinding(VisualEffect component)
    {
        if (_driver.volumeRenderTexture == null) return;

        component.SetTexture(_volumetricDataProperty, _driver.volumeRenderTexture);
        component.SetTexture(_positionDataProperty, _driver.positionRenderTexture);
        component.SetFloat(_valueScaleProperty, _driver.valueScale);
        component.SetVector3(_physicalExtentProperty, _driver.physicalExtent);
    }

    public override string ToString()
      => $"Cube: {_volumetricDataProperty}, {_positionDataProperty}, {_valueScaleProperty}, {_physicalExtentProperty}";
}
